/*
 * Decompiled with CFR 0.152.
 */
package romacorecoilgui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import romacorecoilgui.Listener;
import romacorecoilgui.RomacoRecoilGUIView;

public class NetSocket
extends Thread {
    Socket sock = null;
    byte[] file = null;
    ServerSocket serverSocket = null;
    Listener listnr;
    RomacoRecoilGUIView rview;
    boolean isserver;
    String address;
    boolean getaddress;
    boolean isfirst;

    public NetSocket(boolean getaddress, boolean isserver, String address, RomacoRecoilGUIView rview) {
        this.rview = rview;
        this.isserver = isserver;
        this.address = address;
        this.getaddress = getaddress;
        this.isfirst = !isserver;
    }

    public void run() {
        try {
            this.listen(this.isserver);
        }
        catch (Exception e) {
            System.err.println("Error 11: Could not listen on socket.");
            System.exit(1);
        }
    }

    public void send(String filepath) throws IOException {
        filepath = filepath.replaceFirst("file://", "");
        filepath = filepath.replaceAll(" ", "");
        filepath = filepath.replaceAll("%20", " ");
        File fin = new File(filepath);
        FileInputStream fis = new FileInputStream(fin);
        this.connect(this.isserver, this.address);
        OutputStream os = this.sock.getOutputStream();
        if (fin.length() > Integer.MAX_VALUE) {
            System.err.println("Error 3: File too large.");
            System.exit(1);
        } else {
            this.file = new byte[(int)fin.length()];
        }
        byte[] fsizetmp = Integer.toString((int)fin.length()).getBytes();
        byte[] fsize = new byte[11];
        System.arraycopy(fsizetmp, 0, fsize, 0, fsizetmp.length);
        os.write(fsize);
        fis.read(this.file);
        os.write(this.file);
        os.flush();
        System.out.println("File sent sucessfully.");
        fis.close();
    }

    public void sendAddress() throws IOException {
        OutputStream os = this.sock.getOutputStream();
        byte[] ipaddress = new byte[15];
        try {
            InetAddress addr = InetAddress.getLocalHost();
            byte[] addrtmp = addr.getHostAddress().getBytes();
            System.arraycopy(addrtmp, 0, ipaddress, 0, addrtmp.length);
        }
        catch (UnknownHostException e) {
            System.err.println("Error 12: Could not determine the host address.");
            System.exit(1);
        }
        os.write(ipaddress);
        os.flush();
        System.out.println("Address sent sucessfully.");
    }

    public void connect(boolean isserver, String address) throws IOException {
        int port = isserver ? 8889 : 8888;
        try {
            this.sock = new Socket(address, port);
            System.out.println("Connected to server...");
        }
        catch (UnknownHostException e) {
            System.err.println("Error 1: Cannot find host " + address);
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Error 2: Connection to " + address + " failed.");
            System.exit(1);
        }
        if (!isserver && this.isfirst) {
            this.sendAddress();
            this.isfirst = false;
        }
        this.rview.enableInterface();
    }

    public void listen(boolean isserver) throws IOException {
        int port = isserver ? 8888 : 8889;
        try {
            this.serverSocket = new ServerSocket(port);
            System.out.println("Socket created...\nWaiting for client connection...");
        }
        catch (IOException e) {
            System.err.println("Error 4: Could not listen on port " + port + ".");
            System.exit(1);
        }
        this.listnr = this.getaddress ? new Listener(true, this.sock, this.serverSocket, this.rview, this) : new Listener(false, this.sock, this.serverSocket, this.rview, this);
        this.listnr.start();
        if (!isserver) {
            this.connect(isserver, this.address);
        }
    }
}

