/*
 * Decompiled with CFR 0.152.
 */
package romacorecoilgui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import romacorecoilgui.NetSocket;
import romacorecoilgui.RomacoRecoilGUIAboutBox;
import romacorecoilgui.RomacoRecoilGUIApp;

public class RomacoRecoilGUIView
extends FrameView {
    NetSocket nets;
    String tmppath;
    private JButton btn_clear;
    private JButton btn_connect;
    private JButton btn_savercvd;
    private JButton btn_send;
    private ButtonGroup btngroup_computernum;
    private JLabel lbl_address;
    private JLabel lbl_copyright;
    private JLabel lbl_instructions;
    private JLabel lbl_logo;
    private JLabel lbl_send;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JProgressBar progressBar;
    private JRadioButton rbtn_client2;
    private JRadioButton rbtn_server1;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JTextField tfld_address;
    private JTextField tfld_inputfile;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public RomacoRecoilGUIView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RomacoRecoilGUIView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RomacoRecoilGUIView.this.busyIconIndex = (RomacoRecoilGUIView.this.busyIconIndex + 1) % RomacoRecoilGUIView.this.busyIcons.length;
                RomacoRecoilGUIView.this.statusAnimationLabel.setIcon(RomacoRecoilGUIView.this.busyIcons[RomacoRecoilGUIView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!RomacoRecoilGUIView.this.busyIconTimer.isRunning()) {
                        RomacoRecoilGUIView.this.statusAnimationLabel.setIcon(RomacoRecoilGUIView.this.busyIcons[0]);
                        RomacoRecoilGUIView.this.busyIconIndex = 0;
                        RomacoRecoilGUIView.this.busyIconTimer.start();
                    }
                    RomacoRecoilGUIView.this.progressBar.setVisible(true);
                    RomacoRecoilGUIView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    RomacoRecoilGUIView.this.busyIconTimer.stop();
                    RomacoRecoilGUIView.this.statusAnimationLabel.setIcon(RomacoRecoilGUIView.this.idleIcon);
                    RomacoRecoilGUIView.this.progressBar.setVisible(false);
                    RomacoRecoilGUIView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    RomacoRecoilGUIView.this.statusMessageLabel.setText(text == null ? "" : text);
                    RomacoRecoilGUIView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    RomacoRecoilGUIView.this.progressBar.setVisible(true);
                    RomacoRecoilGUIView.this.progressBar.setIndeterminate(false);
                    RomacoRecoilGUIView.this.progressBar.setValue(value);
                }
            }
        });
        this.tfld_address.setVisible(false);
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = RomacoRecoilGUIApp.getApplication().getMainFrame();
            this.aboutBox = new RomacoRecoilGUIAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        RomacoRecoilGUIApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.rbtn_server1 = new JRadioButton();
        this.rbtn_client2 = new JRadioButton();
        this.lbl_logo = new JLabel();
        this.btn_savercvd = new JButton();
        this.lbl_instructions = new JLabel();
        this.tfld_address = new JTextField();
        this.btn_connect = new JButton();
        this.tfld_inputfile = new JTextField();
        this.lbl_address = new JLabel();
        this.lbl_send = new JLabel();
        this.btn_send = new JButton();
        this.btn_clear = new JButton();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.lbl_copyright = new JLabel();
        this.btngroup_computernum = new ButtonGroup();
        this.mainPanel.setName("mainPanel");
        ApplicationActionMap actionMap = Application.getInstance(RomacoRecoilGUIApp.class).getContext().getActionMap(RomacoRecoilGUIView.class, this);
        this.rbtn_server1.setAction(actionMap.get("rbtn_server1_click"));
        this.btngroup_computernum.add(this.rbtn_server1);
        ResourceMap resourceMap = Application.getInstance(RomacoRecoilGUIApp.class).getContext().getResourceMap(RomacoRecoilGUIView.class);
        this.rbtn_server1.setText(resourceMap.getString("rbtn_server1.text", new Object[0]));
        this.rbtn_server1.setName("rbtn_server1");
        this.rbtn_client2.setAction(actionMap.get("rbtn_client2_click"));
        this.btngroup_computernum.add(this.rbtn_client2);
        this.rbtn_client2.setText(resourceMap.getString("rbtn_client2.text", new Object[0]));
        this.rbtn_client2.setName("rbtn_client2");
        this.lbl_logo.setIcon(resourceMap.getIcon("lbl_logo.icon"));
        this.lbl_logo.setText(resourceMap.getString("lbl_logo.text", new Object[0]));
        this.lbl_logo.setName("lbl_logo");
        this.btn_savercvd.setAction(actionMap.get("btn_save_click"));
        this.btn_savercvd.setText(resourceMap.getString("btn_savercvd.text", new Object[0]));
        this.btn_savercvd.setEnabled(false);
        this.btn_savercvd.setName("btn_savercvd");
        this.lbl_instructions.setText(resourceMap.getString("lbl_instructions.text", new Object[0]));
        this.lbl_instructions.setName("lbl_instructions");
        this.tfld_address.setText(resourceMap.getString("tfld_address.text", new Object[0]));
        this.tfld_address.setName("tfld_address");
        this.btn_connect.setAction(actionMap.get("btn_connect_click"));
        this.btn_connect.setText(resourceMap.getString("btn_connect.text", new Object[0]));
        this.btn_connect.setEnabled(false);
        this.btn_connect.setName("btn_connect");
        this.tfld_inputfile.setText(resourceMap.getString("tfld_inputfile.text", new Object[0]));
        this.tfld_inputfile.setDragEnabled(true);
        this.tfld_inputfile.setEnabled(false);
        this.tfld_inputfile.setMinimumSize(new Dimension(10, 30));
        this.tfld_inputfile.setName("tfld_inputfile");
        this.tfld_inputfile.setPreferredSize(new Dimension(87, 30));
        this.lbl_address.setText(resourceMap.getString("lbl_address.text", new Object[0]));
        this.lbl_address.setName("lbl_address");
        this.lbl_send.setText(resourceMap.getString("lbl_send.text", new Object[0]));
        this.lbl_send.setName("lbl_send");
        this.btn_send.setAction(actionMap.get("btn_send_click"));
        this.btn_send.setText(resourceMap.getString("btn_send.text", new Object[0]));
        this.btn_send.setEnabled(false);
        this.btn_send.setName("btn_send");
        this.btn_clear.setAction(actionMap.get("btn_clear_click"));
        this.btn_clear.setText(resourceMap.getString("btn_clear.text", new Object[0]));
        this.btn_clear.setEnabled(false);
        this.btn_clear.setName("btn_clear");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(19, 19, 19).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lbl_logo).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.rbtn_server1).addGap(18, 18, 18).addComponent(this.rbtn_client2))).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(34, 34, 34).addComponent(this.lbl_address).addGap(20, 20, 20)).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 246, Short.MAX_VALUE).addComponent(this.tfld_address, -2, 195, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btn_connect)))).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lbl_instructions)).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lbl_send)).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tfld_inputfile, -2, 520, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btn_clear, -1, 72, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.btn_send, -1, 216, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btn_savercvd, -2, 376, -2))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lbl_instructions).addGap(34, 34, 34).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rbtn_server1).addComponent(this.rbtn_client2).addComponent(this.lbl_address).addComponent(this.tfld_address, -2, -1, -2).addComponent(this.btn_connect)).addGap(23, 23, 23).addComponent(this.lbl_send).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfld_inputfile, -1, 78, Short.MAX_VALUE).addComponent(this.btn_clear, -1, 78, Short.MAX_VALUE)).addGap(33, 33, 33).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btn_savercvd, -2, 78, -2).addComponent(this.btn_send, -1, 80, Short.MAX_VALUE)).addGap(30, 30, 30).addComponent(this.lbl_logo).addContainerGap()));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        this.lbl_copyright.setText(resourceMap.getString("lbl_copyright.text", new Object[0]));
        this.lbl_copyright.setName("lbl_copyright");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbl_copyright).addGap(18, 18, 18).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 249, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, statusPanelLayout.createSequentialGroup().addComponent(this.progressBar, -2, 166, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()))));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)).addGroup(statusPanelLayout.createSequentialGroup().addComponent(this.lbl_copyright).addContainerGap()));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    @Action
    public void rbtn_server1_click() {
        this.lbl_instructions.setText("Click 'Start' to begin.");
        this.btn_connect.setEnabled(true);
        this.btn_connect.setText("Start");
        this.tfld_address.setVisible(false);
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.lbl_address.setText("Computer 1's address is: " + addr.getHostAddress());
        }
        catch (UnknownHostException e) {
            System.err.println("Error 12: Could not determine the host address.");
            System.exit(1);
        }
    }

    @Action
    public void rbtn_client2_click() {
        this.lbl_instructions.setText("Enter computer #1's address into the box below, and click 'Connect'.");
        this.lbl_address.setText("Computer 1's address: ");
        this.btn_connect.setEnabled(true);
        this.tfld_address.setVisible(true);
        this.btn_connect.setText("Connect");
    }

    @Action
    public void btn_connect_click() throws IOException {
        if (this.rbtn_server1.isSelected()) {
            this.nets = new NetSocket(true, true, null, this);
            this.nets.start();
        } else if (!this.tfld_address.getText().equals("")) {
            this.nets = new NetSocket(false, false, this.tfld_address.getText(), this);
            this.nets.start();
            this.tfld_address.setEnabled(false);
        }
        this.btn_connect.setEnabled(false);
    }

    @Action
    public void btn_send_click() throws IOException {
        String filepath = this.tfld_inputfile.getText();
        this.nets.send(filepath);
    }

    @Action
    public void btn_save_click() {
        String wd = System.getProperty("user.dir");
        JFileChooser fc = new JFileChooser(wd);
        int rc = fc.showDialog(null, "Save Recieved File");
        if (rc == 0) {
            File file = fc.getSelectedFile();
            String savefilename = file.getAbsolutePath();
            try {
                this.copy(this.tmppath, savefilename);
                this.btn_savercvd.setEnabled(false);
            }
            catch (Exception e) {
                System.err.println("Error 13: Could not save recieved file.");
                JOptionPane.showMessageDialog(null, "Error 13: Could not save recieved file.");
            }
        }
    }

    public void enableSave() {
        this.btn_savercvd.setEnabled(true);
    }

    public void enableInterface() {
        this.btn_send.setEnabled(true);
        this.btn_clear.setEnabled(true);
        this.tfld_inputfile.setEnabled(true);
    }

    void copy(String source, String dest) throws IOException {
        int len;
        File src = new File(source);
        File dst = new File(dest);
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    @Action
    public void btn_clear_click() {
        this.tfld_inputfile.setText("");
    }
}

